﻿<# 
  Title    : NTLM → Kerberos Toolkit
  Author   : chader.fr
  Created  : 2025-08-31 (UTC)
  License  : MIT
  Note     : Ce script est "signé" par insertion de l'auteur dans l'en-tête.
             (Signature cryptographique non appliquée depuis cet environnement.)
#>

[CmdletBinding()]
param(
  [Parameter(Mandatory=$true)][string]$InputCsv,
  [string]$OutputPath = ".\NTLM-Audit-Report"
)

$ErrorActionPreference = 'Stop'
if (-not (Test-Path $InputCsv)) {
  throw "Fichier introuvable: $InputCsv"
}

$data = Import-Csv -Path $InputCsv

$new = New-Item -ItemType Directory -Path $OutputPath -Force
$ts = (Get-Date -Format "yyyyMMdd-HHmm")

function TopN($groupProp, $n=20, $name="") {
  $res = $data | Group-Object -Property $groupProp | Sort-Object Count -Descending | Select-Object -First $n
  $out = $res | ForEach-Object {
    [pscustomobject]@{ Item = $_.Name; Count = $_.Count }
  }
  $file = Join-Path $new.FullName ("Top{0}_{1}_{2}.csv" -f $n, $name, $ts)
  $out | Export-Csv -NoTypeInformation -Encoding UTF8 $file
  Write-Host "Généré: $file"
  return $out
}

$topSources = TopN -groupProp Source -n 20 -name "Sources"
$topTargets = TopN -groupProp Target -n 20 -name "Targets"
$topWorkstations = TopN -groupProp Workstation -n 20 -name "Workstations"

# Paires Source→Target (si présentes)
$paired = $data | Group-Object -Property @{Expression={"$($_.Source)|$($_.Target)"} } | Sort-Object Count -Descending | Select-Object -First 20 |
  ForEach-Object {
    $s,$t = $_.Name -split "\|",2
    [pscustomobject]@{ Source=$s; Target=$t; Count=$_.Count }
  }
$pairedFile = Join-Path $new.FullName ("Top20_Pairs_{0}.csv" -f $ts)
$paired | Export-Csv -NoTypeInformation -Encoding UTF8 $pairedFile
Write-Host "Généré: $pairedFile"

# Résumé console
"=== Résumé NTLM (Top 5) ==="
"Sources:"
$topSources | Select-Object -First 5 | Format-Table -AutoSize | Out-String | Write-Host
"Targets:"
$topTargets | Select-Object -First 5 | Format-Table -AutoSize | Out-String | Write-Host
"Workstations:"
$topWorkstations | Select-Object -First 5 | Format-Table -AutoSize | Out-String | Write-Host
"Pairs:"
$paired | Select-Object -First 5 | Format-Table -AutoSize | Out-String | Write-Host
