﻿<# 
  Title    : NTLM → Kerberos Toolkit
  Author   : chader.fr
  Created  : 2025-08-31 (UTC)
  License  : MIT
  Note     : Ce script est "signé" par insertion de l'auteur dans l'en-tête.
             (Signature cryptographique non appliquée depuis cet environnement.)
#>

[CmdletBinding()]
param(
  [string]$GpoName = "Restrict NTLM - Rached (Pilot)",
  [switch]$LinkToOU,
  [string]$OU, # ex: "OU=Pilote,DC=contoso,DC=com"
  [string[]]$ServerExceptions # optionnel: FQDN de serveurs autorisés
)

Import-Module GroupPolicy -ErrorAction Stop

$gpo = Get-GPO -Name $GpoName -ErrorAction SilentlyContinue
if (-not $gpo) {
  $gpo = New-GPO -Name $GpoName -Comment "Restriction NTLM (Rached)"
}

# Bloque l'authentification NTLM pour comptes de domaine
# HKLM\SYSTEM\CurrentControlSet\Control\Lsa\MSV1_0\RestrictReceivingNTLMTraffic = 2
Set-GPRegistryValue -Name $GpoName -Key "HKLM\SYSTEM\CurrentControlSet\Control\Lsa\MSV1_0" -ValueName "RestrictReceivingNTLMTraffic" -Type DWord -Value 2

# Exceptions (clients autorisés) si nécessaire
if ($ServerExceptions) {
  $list = ';'.Join(';', $ServerExceptions)
  # HKLM\System\CurrentControlSet\Control\Lsa\MSV1_0\ClientAllowedNTLMServers (REG_SZ) - liste ; séparée
  Set-GPRegistryValue -Name $GpoName -Key "HKLM\SYSTEM\CurrentControlSet\Control\Lsa\MSV1_0" -ValueName "ClientAllowedNTLMServers" -Type String -Value $list
}

if ($LinkToOU -and $OU) {
  New-GPLink -Name $GpoName -Target $OU -Enforced:$false
}

Write-Host "GPO prêt: $GpoName"
