﻿<# 
  Title    : NTLM → Kerberos Toolkit
  Author   : chader.fr
  Created  : 2025-08-31 (UTC)
  License  : MIT
  Note     : Ce script est "signé" par insertion de l'auteur dans l'en-tête.
             (Signature cryptographique non appliquée depuis cet environnement.)
#>

[CmdletBinding()]
param(
  [string]$GpoName = "Audit NTLM - Rached",
  [switch]$LinkToOU,
  [string]$OU # ex: "OU=Pilote,DC=contoso,DC=com"
)

Import-Module GroupPolicy -ErrorAction Stop

# Crée ou récupère le GPO
$gpo = Get-GPO -Name $GpoName -ErrorAction SilentlyContinue
if (-not $gpo) {
  $gpo = New-GPO -Name $GpoName -Comment "Audit NTLM (Rached)"
}

# Active l'audit NTLM (audit only)
# HKLM\SYSTEM\CurrentControlSet\Control\Lsa\MSV1_0\AuditReceivingNTLMTraffic = 2
Set-GPRegistryValue -Name $GpoName -Key "HKLM\SYSTEM\CurrentControlSet\Control\Lsa\MSV1_0" -ValueName "AuditReceivingNTLMTraffic" -Type DWord -Value 2

# Lien sur une OU si demandé
if ($LinkToOU -and $OU) {
  New-GPLink -Name $GpoName -Target $OU -Enforced:$false
}

Write-Host "GPO prêt: $GpoName"
