
# NTLM → Kerberos Toolkit — Author   : chader.fr

Ce pack contient tout le nécessaire pour auditer NTLM, analyser, et préparer la restriction/migration vers Kerberos.

## Contenu

- **Audit-NTLM.ps1** : collecte des événements NTLM (IDs 4002/4003) et export CSV.
- **Analyse-NTLM.ps1** : agrégation des résultats (Top 20 sources/targets/paires).
- **Create-GPO-Audit-NTLM.ps1** : crée un GPO "Audit NTLM - Rached" (mode audit only).
- **Create-GPO-Restrict-NTLM.ps1** : crée un GPO "Restrict NTLM - Rached (Pilot)" (deny comptes de domaine) + exceptions possibles.
- **Link-GPO.ps1** : lie un GPO à une OU.
- **/docs** : ce README.

## Prérequis
- Windows Server 2019/2022
- Module **GroupPolicy** (RSAT) pour la création de GPO
- (Optionnel) Module **ActiveDirectory** pour l’option `-AllDomainControllers`

## Usage rapide

### 1) Audit (14 jours par défaut)
```powershell
.\Audit-NTLM.ps1 -AllDomainControllers -OutputPath .\NTLM-Report -IncludeBlocked
```

### 2) Analyse
```powershell
.\Analyse-NTLM.ps1 -InputCsv .\NTLM-Report\Audit-NTLM_YYYYMMDD-HHMM.csv -OutputPath .\NTLM-Report
```

### 3) GPO Audit (audit only) + lien sur une OU pilote
```powershell
.\Create-GPO-Audit-NTLM.ps1 -LinkToOU -OU "OU=Pilote,DC=contoso,DC=com"
```

### 4) GPO Restrict (deny) — à déployer APRÈS correction des dépendances
```powershell
.\Create-GPO-Restrict-NTLM.ps1 -LinkToOU -OU "OU=Pilote,DC=contoso,DC=com" -ServerExceptions "srv-legacy.contoso.com","appliance.contoso.com"
```

> Conseil : déployer d’abord en **Audit** 2 à 4 semaines. Étendre **Restrict** par vagues (OU par OU).

## Signature
Les scripts sont signés **dans l’en-tête** par l’auteur : *Rached (chader.fr)*.  
(Pour une signature code Authenticode, utiliser un certificat de signature de code avec `Set-AuthenticodeSignature`.)

---
